package Decorator;

public class Main {
    public static void main(String[] args) {
        // Creazione di un biscotto base
        Biscotto biscotto = new BiscottoBase();
        System.out.println(biscotto.prepara()); // Output: Biscotto base preparato

        // Aggiunta della glassa al cioccolato e granella di nocciole al biscotto base
        Biscotto biscottoConGlassaENocciole = new GranellaNoccioleDecorator(new GlassaCioccolatoDecorator(biscotto));
        System.out.println(biscottoConGlassaENocciole.prepara()); // Output: Biscotto base preparato con glassa al cioccolato con granella di nocciole

        Biscotto biscottoConGlassaENocciole2 = new GlassaCioccolatoDecorator(new GranellaNoccioleDecorator(biscotto));
        System.out.println(biscottoConGlassaENocciole2.prepara());
        // Aggiunta della glassa al cioccolato, granella di nocciole e ripieno alla crema al biscotto base
        DecoratorBiscotto biscottoConTutteLeFunzionalita = new RipienoCremaDecorator(biscottoConGlassaENocciole);
        System.out.println(biscottoConTutteLeFunzionalita.prepara()); // Output: Biscotto base preparato con glassa al cioccolato con granella di nocciole con ripieno alla crema
    }
}